/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pa.admin.PAStatisticsSnapShot;
import filenet.pa.publisher.PublisherStatisticsSnapShot;
import filenet.pa.sql.DatabaseType;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.PANodeUtil;
import filenet.vw.apps.taskman.pa.PASchedulerPanel;
import filenet.vw.apps.taskman.pa.eventlog.EventLogMainPanel;
import filenet.vw.apps.taskman.pa.monitor.PAStatisticFormatter;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.VWTaskLoggingPanel;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class PAPropertyPanel
extends VWTaskPropertyPanel {
    PANode m_node = null;
    VWTaskTabbedPane m_tabbedPane = null;
    JLabel m_iconLabel = null;
    PAStatisticFormatter m_formatter = new PAStatisticFormatter();
    JTextField m_paStatus = null;
    JTextField m_numberOfPEPublishedEvents = null;
    JTextField m_numberOfCECommittedEvents = null;
    JTextField m_numberOfCEPublishedEvents = null;
    JTextField m_numberOfPEErroneousEvents = null;
    JTextField m_numberOfCEErroneousEvents = null;
    JLabel m_erroneousPEEventsLabel = null;
    JLabel m_erroneousCEEventsLabel = null;
    ConnectedRegionsPanel m_connectedRegionsPanel = null;
    JTextField m_tempDir = null;
    VWTaskNumericProperty m_registryPort = null;
    VWTaskNumericProperty m_publishInterval = null;
    VWTaskNumericProperty m_javaMinMem = null;
    VWTaskNumericProperty m_javaMaxMem = null;
    VWTaskNumericProperty m_numberPublisherThreads = null;
    JTextField m_ceURL = null;
    JTextField m_serviceUserName = null;
    JPasswordField m_servicePassword = null;
    JTextField m_paDBHost = null;
    VWTaskNumericProperty m_paDBPort = null;
    JTextField m_paDBInstance = null;
    JTextField m_paDBName = null;
    JTextField m_paOLAPInstance = null;
    JTextField m_paOLAPDBName = null;
    JTextField m_paOLAPHost = null;
    JTextField m_paDBUser = null;
    JPasswordField m_paDBPassword = null;
    JTextField m_paDBDriverName = null;
    JTextArea m_paDBDriverClasspath = null;
    JComboBox m_peDBType = null;
    JTextField m_peDBHost = null;
    VWTaskNumericProperty m_peDBPort = null;
    JTextField m_peDBName = null;
    JTextField m_peDBUser = null;
    JPasswordField m_peDBPassword = null;
    JTextField m_peDBDriverName = null;
    JTextArea m_peDBDriverClasspath = null;
    JCheckBox m_peProcessEvents = null;
    JCheckBox m_ceProcessEvents = null;
    JTextField m_ceObjectStore = null;
    VWTaskNumericProperty m_dimensionCacheSize = null;
    VWTaskNumericProperty m_factCacheSize = null;
    JComboBox m_showAdjMeasures = null;
    PASchedulerPanel m_schedulerPanel = null;
    VWTaskLoggingPanel m_loggingPanel = null;
    EventLogMainPanel m_eventLogPanel = null;
    JTextField m_connectedCEObjectStore = null;
    JPanel m_PEStatusStatisticsPanel = null;
    JPanel m_CEStatusStatisticsPanel = null;
    boolean m_bPEErroneousEventsPresent = false;
    boolean m_bCEErroneousEventsPresent = false;
    private static final boolean REQUIRED = true;
    private static final boolean NOT_REQUIRED = false;
    private static final String MSSQL_JDBC_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String ORACLE_JDBC_DRIVER = "oracle.jdbc.OracleDriver";
    private static final String DB2_JDBC_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final int MSSQL_JDBC_PORT = 1433;
    private static final int ORACLE_JDBC_PORT = 1521;
    private static final int DB2_JDBC_PORT = 50000;

    public PAPropertyPanel(PANode node) throws Exception {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = node;
        this.addTabbedPane();
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
    }

    public void refresh() {
        boolean stopped = !this.m_node.isStarted();
        this.m_iconLabel.setIcon(this.m_node.getIcon32());
        this.m_registryPort.setEditable(stopped);
        this.m_javaMinMem.setEditable(stopped);
        this.m_javaMaxMem.setEditable(stopped);
        this.m_numberPublisherThreads.setEditable(stopped);
        this.m_dimensionCacheSize.setEditable(stopped);
        this.m_factCacheSize.setEditable(stopped);
        this.m_loggingPanel.setEnabled(stopped);
        this.m_showAdjMeasures.setEnabled(stopped);
        this.m_eventLogPanel.refresh();
        this.m_peProcessEvents.setEnabled(stopped);
        this.m_ceProcessEvents.setEnabled(stopped);
        if (stopped) {
            this.updateStatistics(null);
        } else if (this.m_paStatus.getText().equals(VWResource.Stopped)) {
            this.setStatus(VWResource.Running);
        }
    }

    protected EventLogMainPanel getEventLogPanel() {
        return this.m_eventLogPanel;
    }

    protected String getContentEngineURL() {
        return this.m_ceURL.getText().trim();
    }

    protected String getServiceUsername() {
        return this.m_serviceUserName.getText().trim();
    }

    protected String getServicePassword() {
        return new String(this.m_servicePassword.getPassword());
    }

    protected String getObjectStore() {
        return new String(this.m_ceObjectStore.getText().trim());
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object src = event.getSource();
        if (src.equals(this.m_ceProcessEvents)) {
            this.m_ceObjectStore.setEnabled(this.m_ceProcessEvents.isSelected());
        }
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_tabbedPane.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    public void applyProperties() throws Exception {
        this.applyPropertiesOnAction(null);
    }

    public boolean applyPropertiesOnAction(String action) throws Exception {
        boolean curValue;
        PANodeUtil util = new PANodeUtil();
        Properties props = (Properties)this.m_node.getPAProperties().clone();
        boolean applied = this.m_eventLogPanel.applyProperties();
        if (!applied) {
            return false;
        }
        props.setProperty("analyzer.uncprefix", this.m_tempDir.getText().trim());
        props.setProperty("analyzer.rmiPortNumber", this.m_registryPort.getText().trim());
        props.setProperty("analyzer.heartbeat.interval", this.m_publishInterval.getText().trim());
        props.setProperty("analyzer.javaMinMem", this.m_javaMinMem.getText().trim());
        props.setProperty("analyzer.javaMaxMem", this.m_javaMaxMem.getText().trim());
        props.setProperty("analyzer.thread.publisher.count", this.m_numberPublisherThreads.getText().trim());
        props.setProperty("analyzer.ce.url", this.m_ceURL.getText().trim());
        props.setProperty(VWResource.S_PROPERTIES_PE_PROCESSEVENTS, Boolean.valueOf(this.m_peProcessEvents.isSelected()).toString());
        if (Boolean.valueOf(this.m_peProcessEvents.isSelected()).booleanValue()) {
            this.m_peProcessEvents.setSelected(true);
            this.m_PEStatusStatisticsPanel.removeAll();
            this.getStatusStatisticsPanel();
            this.m_numberOfPEErroneousEvents.setVisible(this.m_bPEErroneousEventsPresent);
            this.m_erroneousPEEventsLabel.setVisible(this.m_bPEErroneousEventsPresent);
        } else {
            this.m_peProcessEvents.setSelected(false);
            this.m_PEStatusStatisticsPanel.removeAll();
            this.m_PEStatusStatisticsPanel.setBorder(null);
        }
        props.setProperty(VWResource.S_PROPERTIES_CE_PROCESSEVENTS, Boolean.valueOf(this.m_ceProcessEvents.isSelected()).toString());
        if (Boolean.valueOf(this.m_ceProcessEvents.isSelected()).booleanValue()) {
            this.m_ceProcessEvents.setSelected(true);
            this.m_CEStatusStatisticsPanel.removeAll();
            this.getStatusCEStatisticsPanel();
            this.m_numberOfCEErroneousEvents.setVisible(this.m_bCEErroneousEventsPresent);
            this.m_erroneousCEEventsLabel.setVisible(this.m_bCEErroneousEventsPresent);
        } else {
            this.m_ceProcessEvents.setSelected(false);
            this.m_CEStatusStatisticsPanel.removeAll();
            this.m_CEStatusStatisticsPanel.setBorder(null);
        }
        props.setProperty(VWResource.S_PROPERTIES_CE_OBJECTSTORE, this.m_ceObjectStore.getText().trim());
        props.setProperty("analyzer.ce.token", util.getEString(this.m_serviceUserName.getText().trim(), new String(this.m_servicePassword.getPassword())));
        props.setProperty("analyzer.db.server", this.m_paDBHost.getText().trim());
        props.setProperty("analyzer.db.port", this.m_paDBPort.getText().trim());
        props.setProperty("analyzer.db.instance", this.m_paDBInstance.getText().trim());
        props.setProperty("analyzer.db.name", this.m_paDBName.getText().trim());
        props.setProperty("analyzer.db.token", util.getEString(this.m_paDBUser.getText().trim(), new String(this.m_paDBPassword.getPassword())));
        props.setProperty("analyzer.olap.instance", this.m_paOLAPInstance.getText().trim());
        props.setProperty("analyzer.olap.dbname", this.m_paOLAPDBName.getText().trim());
        props.setProperty("analyzer.olap.server", this.m_paOLAPHost.getText().trim());
        String paJDBCClasspath = this.m_paDBDriverClasspath.getText().trim();
        boolean paJDBCClasspathChanged = props.getProperty("analyzer.db.jdbcdriver.classpath", "").compareTo(paJDBCClasspath) != 0;
        props.setProperty("analyzer.db.jdbcdriver.classpath", paJDBCClasspath);
        props.setProperty("analyzer.db.jdbcdriver", this.m_paDBDriverName.getText().trim());
        props.setProperty("analyzer.pedb.type", ((DatabaseTypeWrapper)this.m_peDBType.getSelectedItem()).getName());
        props.setProperty("analyzer.pedb.server", this.m_peDBHost.getText().trim());
        props.setProperty("analyzer.pedb.port", this.m_peDBPort.getText().trim());
        props.setProperty("analyzer.pedb.name", this.m_peDBName.getText().trim());
        props.setProperty("analyzer.pedb.token", util.getEString(this.m_peDBUser.getText().trim(), new String(this.m_peDBPassword.getPassword())));
        String peJDBCClasspath = this.m_peDBDriverClasspath.getText().trim();
        boolean peJDBCClasspathChanged = props.getProperty("analyzer.pedb.jdbcdriver.classpath", "").compareTo(peJDBCClasspath) != 0;
        props.setProperty("analyzer.pedb.jdbcdriver.classpath", peJDBCClasspath);
        props.setProperty("analyzer.pedb.jdbcdriver", this.m_peDBDriverName.getText().trim());
        props.setProperty("analyzer.fact.MaxCacheSize", this.m_factCacheSize.getText().trim());
        props.setProperty("analyzer.cachesize", this.m_dimensionCacheSize.getText().trim());
        props.setProperty("analyzer.logfile", this.m_loggingPanel.getLogPath());
        props.setProperty("analyzer.loglevel", this.m_loggingPanel.getLogLevel().toString());
        this.m_schedulerPanel.applyProperties(props);
        boolean bShowAdjustedMeasures = false;
        boolean bShowAdjustedMeasuresChanged = false;
        if (!this.m_node.isStarted() && (bShowAdjustedMeasures = ((String)this.m_showAdjMeasures.getSelectedItem()).equals(VWResource.On)) != (curValue = new Boolean(props.getProperty("analyzer.showAdjustedMeasures")).booleanValue())) {
            bShowAdjustedMeasuresChanged = true;
            props.setProperty("analyzer.showAdjustedMeasures", new Boolean(bShowAdjustedMeasures).toString());
        }
        FileOutputStream propFile = null;
        try {
            propFile = new FileOutputStream(this.m_node.getPAPropertiesPath(), false);
            props.store(propFile, null);
            this.m_node.setPAProperties(props);
        }
        catch (Exception e) {
            throw new VWException("vw.apps.taskman.pa.VWPAPropertyPanel.ErrorUpdatingPropsFile", "Error updating {0} properties file: {1}", VWResource.ProcessAnalyzer, e.getLocalizedMessage());
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                    propFile = null;
                }
                catch (Exception e) {}
            }
        }
        if (bShowAdjustedMeasuresChanged) {
            try {
                this.m_node.changeAdjustedMeasureSetting(bShowAdjustedMeasures);
            }
            catch (VWException ex) {
                String key = ex.getKey();
                if (key != null && key.startsWith("pa.publisher.udf.UDFAdmin.OLAPException")) {
                    VWTaskCore.getInstance().displayWarning(ex.getMessage());
                }
                throw ex;
            }
        }
        if (paJDBCClasspathChanged || peJDBCClasspathChanged) {
            this.m_node.refresh();
        }
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
        return true;
    }

    public void resetProperties() throws Exception {
        Properties props = this.m_node.getPAProperties();
        this.m_tempDir.setText(props.getProperty("analyzer.uncprefix", ""));
        this.m_registryPort.setText(props.getProperty("analyzer.rmiPortNumber", "32771"));
        this.m_publishInterval.setText(props.getProperty("analyzer.heartbeat.interval", ""));
        this.m_javaMinMem.setText(props.getProperty("analyzer.javaMinMem", ""));
        this.m_javaMaxMem.setText(props.getProperty("analyzer.javaMaxMem", ""));
        this.m_numberPublisherThreads.setText(props.getProperty("analyzer.thread.publisher.count", ""));
        this.m_ceURL.setText(props.getProperty("analyzer.ce.url", ""));
        String procEvents = props.getProperty(VWResource.S_PROPERTIES_PE_PROCESSEVENTS, "");
        if (procEvents == "" || Boolean.valueOf(procEvents).booleanValue()) {
            this.m_peProcessEvents.setSelected(true);
            this.m_PEStatusStatisticsPanel.removeAll();
            this.getStatusStatisticsPanel();
            this.m_numberOfPEErroneousEvents.setVisible(this.m_bPEErroneousEventsPresent);
            this.m_erroneousPEEventsLabel.setVisible(this.m_bPEErroneousEventsPresent);
        } else {
            this.m_peProcessEvents.setSelected(false);
            this.m_PEStatusStatisticsPanel.removeAll();
            this.m_PEStatusStatisticsPanel.setBorder(null);
        }
        procEvents = props.getProperty(VWResource.S_PROPERTIES_CE_PROCESSEVENTS, "");
        if (procEvents == "" || Boolean.valueOf(procEvents).booleanValue()) {
            this.m_ceProcessEvents.setSelected(true);
            this.m_CEStatusStatisticsPanel.removeAll();
            this.getStatusCEStatisticsPanel();
            this.m_ceObjectStore.setEnabled(true);
            this.m_numberOfCEErroneousEvents.setVisible(this.m_bCEErroneousEventsPresent);
            this.m_erroneousCEEventsLabel.setVisible(this.m_bCEErroneousEventsPresent);
        } else {
            this.m_ceProcessEvents.setSelected(false);
            this.m_CEStatusStatisticsPanel.removeAll();
            this.m_CEStatusStatisticsPanel.setBorder(null);
            this.m_ceObjectStore.setEnabled(false);
        }
        this.m_ceObjectStore.setText(props.getProperty(VWResource.S_PROPERTIES_CE_OBJECTSTORE, ""));
        VWAuthItem authItem = new PANodeUtil().getDString(props.getProperty("analyzer.ce.token", ""));
        this.m_serviceUserName.setText(authItem != null ? authItem.getName() : "");
        this.m_servicePassword.setText(authItem != null ? authItem.getPassword() : "");
        String paJDBCURL = props.getProperty("analyzer.db.jdbcurl", null);
        if (paJDBCURL != null && !paJDBCURL.equals("")) {
            this.m_paDBHost.setText("");
            this.m_paDBHost.setEditable(false);
            this.m_paDBPort.setText("");
            this.m_paDBPort.setEditable(false);
            this.m_paDBName.setText("");
            this.m_paDBName.setEditable(false);
        } else {
            this.m_paDBHost.setText(props.getProperty("analyzer.db.server", ""));
            this.m_paDBPort.setText(props.getProperty("analyzer.db.port", ""));
            this.m_paDBName.setText(props.getProperty("analyzer.db.name", ""));
        }
        this.m_paDBInstance.setText(props.getProperty("analyzer.db.instance", ""));
        authItem = new PANodeUtil().getDString(props.getProperty("analyzer.db.token", ""));
        this.m_paDBUser.setText(authItem != null ? authItem.getName() : "");
        this.m_paDBPassword.setText(authItem != null ? authItem.getPassword() : "");
        this.m_paDBDriverName.setText(props.getProperty("analyzer.db.jdbcdriver", ""));
        this.m_paDBDriverClasspath.setText(props.getProperty("analyzer.db.jdbcdriver.classpath", ""));
        this.m_paOLAPInstance.setText(props.getProperty("analyzer.olap.instance", ""));
        this.m_paOLAPHost.setText(props.getProperty("analyzer.olap.server", ""));
        this.m_paOLAPDBName.setText(props.getProperty("analyzer.olap.dbname", ""));
        this.m_peDBType.setSelectedItem(DatabaseTypeWrapper.valueOf(props.getProperty("analyzer.pedb.type", DatabaseType.SQLSERVER.getName())));
        String peJDBCURL = props.getProperty("analyzer.pedb.jdbcurl", null);
        if (peJDBCURL != null && !peJDBCURL.equals("")) {
            this.m_peDBHost.setText("");
            this.m_peDBHost.setEditable(false);
            this.m_peDBPort.setText("");
            this.m_peDBPort.setEditable(false);
            this.m_peDBName.setText("");
            this.m_peDBName.setEditable(false);
        } else {
            this.m_peDBHost.setText(props.getProperty("analyzer.pedb.server", ""));
            this.m_peDBPort.setText(props.getProperty("analyzer.pedb.port", ""));
            this.m_peDBName.setText(props.getProperty("analyzer.pedb.name", ""));
        }
        authItem = new PANodeUtil().getDString(props.getProperty("analyzer.pedb.token", ""));
        this.m_peDBUser.setText(authItem != null ? authItem.getName() : "");
        this.m_peDBPassword.setText(authItem != null ? authItem.getPassword() : "");
        String pejdbcdriver = props.getProperty("analyzer.pedb.jdbcdriver", "");
        if (pejdbcdriver == "") {
            this.m_peDBDriverName.setText(pejdbcdriver);
        }
        this.m_peDBDriverClasspath.setText(props.getProperty("analyzer.pedb.jdbcdriver.classpath", ""));
        this.m_dimensionCacheSize.setText(props.getProperty("analyzer.cachesize", ""));
        this.m_factCacheSize.setText(props.getProperty("analyzer.fact.MaxCacheSize", ""));
        this.resetLogSettings();
        String tmp = props.getProperty("analyzer.showAdjustedMeasures");
        if (tmp != null && tmp.compareToIgnoreCase("true") == 0) {
            this.m_showAdjMeasures.setSelectedItem(VWResource.On);
        } else {
            this.m_showAdjMeasures.setSelectedItem(VWResource.Off);
        }
        this.m_schedulerPanel.resetProperties(props);
        if (this.hasValidPEDBConfiguration()) {
            this.m_eventLogPanel.resetProperties();
        }
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    public void updateStatistics(final PAStatisticsSnapShot stats) {
        Runnable doUpdateStatistics = new Runnable(){

            public void run() {
                String paStatus;
                if (stats == null) {
                    PAPropertyPanel.this.setStatus(PAPropertyPanel.this.m_node.isStarted() ? VWResource.Unknown : VWResource.Stopped);
                    PAPropertyPanel.this.clearStatistics();
                    return;
                }
                switch (stats.getCurrentJob()) {
                    case 5: {
                        paStatus = VWResource.Running;
                        break;
                    }
                    case 6: {
                        paStatus = VWResource.ProcessingCubes;
                        break;
                    }
                    case 8: {
                        paStatus = VWResource.PruningEvents;
                        break;
                    }
                    case 7: {
                        paStatus = VWResource.PruningIsolatedRegion;
                        break;
                    }
                    case 9: {
                        paStatus = VWResource.RebuildingOLAP;
                        break;
                    }
                    case 10: {
                        paStatus = VWResource.ProcessingWIPCubes;
                        break;
                    }
                    case 12: {
                        paStatus = VWResource.Upgrading;
                        break;
                    }
                    default: {
                        paStatus = VWResource.Unknown;
                    }
                }
                PAPropertyPanel.this.setStatus(paStatus);
                PAPropertyPanel.this.m_connectedRegionsPanel.setRegions(stats.getConnectedRegions());
                PublisherStatisticsSnapShot pubStats = stats.getPublisherStats();
                if (pubStats != null) {
                    PAPropertyPanel.this.m_numberOfPEPublishedEvents.setText(PAPropertyPanel.this.m_formatter.formatLong(pubStats.getPEEventsPublishedSinceStart()));
                    PAPropertyPanel.this.m_numberOfCEPublishedEvents.setText(PAPropertyPanel.this.m_formatter.formatLong(pubStats.getCEEventsPublishedSinceStart()));
                    PAPropertyPanel.this.m_numberOfPEErroneousEvents.setText(PAPropertyPanel.this.m_formatter.formatLong(pubStats.getNumberOfPEQuarantinedEvents()));
                    PAPropertyPanel.this.m_bPEErroneousEventsPresent = pubStats.getNumberOfPEQuarantinedEvents() > 0;
                    PAPropertyPanel.this.m_numberOfPEErroneousEvents.setVisible(PAPropertyPanel.this.m_bPEErroneousEventsPresent);
                    PAPropertyPanel.this.m_erroneousPEEventsLabel.setVisible(PAPropertyPanel.this.m_bPEErroneousEventsPresent);
                    PAPropertyPanel.this.m_numberOfCEErroneousEvents.setText(PAPropertyPanel.this.m_formatter.formatLong(pubStats.getNumberOfCEQuarantinedEvents()));
                    PAPropertyPanel.this.m_bCEErroneousEventsPresent = pubStats.getNumberOfCEQuarantinedEvents() > 0;
                    PAPropertyPanel.this.m_numberOfCEErroneousEvents.setVisible(PAPropertyPanel.this.m_bCEErroneousEventsPresent);
                    PAPropertyPanel.this.m_erroneousCEEventsLabel.setVisible(PAPropertyPanel.this.m_bCEErroneousEventsPresent);
                    PAPropertyPanel.this.m_connectedCEObjectStore.setVisible(true);
                    PAPropertyPanel.this.m_connectedCEObjectStore.setText(PAPropertyPanel.this.getObjectStore());
                    if (PAPropertyPanel.this.m_numberOfCECommittedEvents != null) {
                        PAPropertyPanel.this.m_numberOfCECommittedEvents.setText(PAPropertyPanel.this.m_formatter.formatLong(pubStats.getPEEventsCommittedSinceStart()));
                    }
                } else {
                    PAPropertyPanel.this.clearStatistics();
                }
            }
        };
        VWTaskUtil.performUIOperation(doUpdateStatistics, true);
    }

    private void clearStatistics() {
        this.m_numberOfPEPublishedEvents.setText("---");
        this.m_numberOfCEPublishedEvents.setText("---");
        this.m_connectedCEObjectStore.setVisible(false);
        this.m_numberOfPEErroneousEvents.setVisible(false);
        this.m_numberOfCEErroneousEvents.setVisible(false);
        this.m_erroneousPEEventsLabel.setVisible(false);
        this.m_erroneousCEEventsLabel.setVisible(false);
        this.m_connectedRegionsPanel.setRegions(null);
        if (this.m_numberOfCECommittedEvents != null) {
            this.m_numberOfCECommittedEvents.setText("---");
        }
    }

    protected void setStatus(final String status) {
        Runnable doSetStatus = new Runnable(){

            public void run() {
                PAPropertyPanel.this.m_paStatus.setText(status);
            }
        };
        VWTaskUtil.performUIOperation(doSetStatus, true);
    }

    private void resetLogSettings() {
        Properties props = this.m_node.getPAProperties();
        String logPath = props.getProperty("analyzer.logfile", null);
        if (logPath == null || logPath.equals("")) {
            logPath = this.m_node.getInstallDirectory() + "calog.txt";
        }
        this.m_loggingPanel.setLogPath(logPath);
        this.m_loggingPanel.setLogLevel(Level.parse(props.getProperty("analyzer.loglevel", Level.WARNING.toString())));
    }

    private void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        this.m_tabbedPane.addTab(VWResource.Status, this.getStatusPanel());
        this.m_tabbedPane.addTab(VWResource.General, this.getGeneralPanel());
        this.m_tabbedPane.addTab(VWResource.Database, this.getDatabasePanel());
        this.m_tabbedPane.addTab(VWResource.ProcessEngine, this.getProcessEnginePanel());
        this.m_tabbedPane.addTab(VWResource.ContentEngine, this.getContentEnginePanel());
        this.m_schedulerPanel = new PASchedulerPanel();
        VWTaskUtil.updateComponentOrientation(this.m_schedulerPanel);
        this.m_schedulerPanel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_scheduler.htm");
        this.m_tabbedPane.addTab(VWResource.Scheduler, this.m_schedulerPanel);
        this.m_tabbedPane.addTab(VWResource.Advanced, this.getAdvancedPanel());
        this.add((Component)this.m_tabbedPane, "Center");
    }

    private VWTaskTabPanel getStatusPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_status.htm");
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 23;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(4, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        panel.add((Component)this.m_iconLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 1;
        c.insets = new Insets(15, 10, 0, 0);
        c.gridwidth = 0;
        String labelStr = null;
        if (this.m_node.isProductionMode()) {
            labelStr = VWResource.ProcessAnalyzer;
        } else if (this.m_node.isSimulationMode()) {
            labelStr = VWResource.SimulationProcessAnalyzer;
        } else if (this.m_node.isMixedMode()) {
            labelStr = VWResource.ProcessAnalyzerDevEnvironment;
        }
        panel.add((Component)new JLabel(labelStr), c);
        c.gridy = 1;
        c.gridx = 0;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(20, 0, 0, 0);
        panel.add((Component)this.getStatusProperties(), c);
        c.gridy = 2;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private JPanel getStatusProperties() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.weighty = 0.0;
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        panel.add((Component)this.getStatusStatusPanel(), c);
        c.gridx = 1;
        c.weightx = 0.0;
        panel.add(Box.createHorizontalStrut(100), c);
        c.insets = new Insets(15, 10, 0, 10);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.m_PEStatusStatisticsPanel = new JPanel(new GridBagLayout());
        this.getStatusStatisticsPanel();
        panel.add((Component)this.m_PEStatusStatisticsPanel, c);
        c.gridx = 1;
        c.weightx = 0.0;
        panel.add(Box.createHorizontalStrut(100), c);
        c.insets = new Insets(15, 10, 0, 10);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.m_CEStatusStatisticsPanel = new JPanel(new GridBagLayout());
        this.getStatusCEStatisticsPanel();
        panel.add((Component)this.m_CEStatusStatisticsPanel, c);
        c.gridx = 1;
        c.weightx = 0.0;
        panel.add(Box.createHorizontalStrut(100), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private JPanel getStatusStatusPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.weighty = 0.0;
        c.insets = new Insets(5, 10, 5, 5);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(VWResource.Status + ":"), c);
        this.m_paStatus = new JTextField(VWResource.Stopped);
        this.m_paStatus.setBorder(null);
        this.m_paStatus.setEditable(false);
        this.m_paStatus.addFocusListener(this);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.m_paStatus, c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private JPanel getStatusStatisticsPanel() {
        JPanel panel = this.m_PEStatusStatisticsPanel;
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add(Box.createHorizontalStrut(1), c);
        c.insets = new Insets(3, 10, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(VWResource.PEEventsPublishedCapital + ":"), c);
        this.m_numberOfPEPublishedEvents = new JTextField();
        this.m_numberOfPEPublishedEvents.setBorder(null);
        this.m_numberOfPEPublishedEvents.setEditable(false);
        this.m_numberOfPEPublishedEvents.addFocusListener(this);
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)this.m_numberOfPEPublishedEvents, c);
        c.insets = new Insets(3, 10, 0, 0);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(VWResource.ConnectedRegions + ":"), c);
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 3;
        this.m_connectedRegionsPanel = new ConnectedRegionsPanel();
        VWTaskUtil.updateComponentOrientation(this.m_connectedRegionsPanel);
        panel.add((Component)this.m_connectedRegionsPanel, c);
        if (this.m_node.getBooleanProperty("TaskManager.CaseAnalyzer.Status.ShowCommittedEvents")) {
            c.insets = new Insets(3, 10, 0, 0);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            panel.add((Component)new JLabel(VWResource.EventsCommitted + ":"), c);
            this.m_numberOfCECommittedEvents = new JTextField();
            this.m_numberOfCECommittedEvents.setBorder(null);
            this.m_numberOfCECommittedEvents.setEditable(false);
            this.m_numberOfCECommittedEvents.addFocusListener(this);
            c.insets = new Insets(3, 10, 0, 10);
            c.gridx = 1;
            c.weightx = 1.0;
            panel.add((Component)this.m_numberOfCECommittedEvents, c);
        }
        c.insets = new Insets(3, 10, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.m_erroneousPEEventsLabel = new JLabel(VWResource.NumberOfPEErroneousEvents + ":");
        this.m_erroneousPEEventsLabel.setForeground(Color.red);
        panel.add((Component)this.m_erroneousPEEventsLabel, c);
        this.m_numberOfPEErroneousEvents = new JTextField();
        this.m_numberOfPEErroneousEvents.setBorder(null);
        this.m_numberOfPEErroneousEvents.setEditable(false);
        this.m_numberOfPEErroneousEvents.setVisible(false);
        this.m_numberOfPEErroneousEvents.addFocusListener(this);
        this.m_numberOfPEErroneousEvents.setForeground(Color.red);
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)this.m_numberOfPEErroneousEvents, c);
        c.insets = new Insets(0, 0, 5, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add(Box.createHorizontalStrut(1), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private JPanel getStatusCEStatisticsPanel() {
        JPanel panel = this.m_CEStatusStatisticsPanel;
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.weighty = 0.0;
        c.insets = new Insets(2, 0, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add(Box.createHorizontalStrut(1), c);
        c.insets = new Insets(3, 10, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(VWResource.CEEventsPublishedCapital + ":"), c);
        this.m_numberOfCEPublishedEvents = new JTextField();
        this.m_numberOfCEPublishedEvents.setBorder(null);
        this.m_numberOfCEPublishedEvents.setEditable(false);
        this.m_numberOfCEPublishedEvents.addFocusListener(this);
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)this.m_numberOfCEPublishedEvents, c);
        c.insets = new Insets(3, 10, 0, 0);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(VWResource.ConnectedObjectStore + ":"), c);
        this.m_connectedCEObjectStore = new JTextField();
        this.m_connectedCEObjectStore.setBorder(null);
        this.m_connectedCEObjectStore.setEditable(false);
        this.m_connectedCEObjectStore.addFocusListener(this);
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)this.m_connectedCEObjectStore, c);
        c.insets = new Insets(3, 10, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.m_erroneousCEEventsLabel = new JLabel(VWResource.NumberOfCEErroneousEvents + ":");
        this.m_erroneousCEEventsLabel.setForeground(Color.red);
        panel.add((Component)this.m_erroneousCEEventsLabel, c);
        this.m_numberOfCEErroneousEvents = new JTextField();
        this.m_numberOfCEErroneousEvents.setBorder(null);
        this.m_numberOfCEErroneousEvents.setEditable(false);
        this.m_numberOfCEErroneousEvents.setVisible(false);
        this.m_numberOfCEErroneousEvents.addFocusListener(this);
        this.m_numberOfCEErroneousEvents.setForeground(Color.red);
        c.insets = new Insets(3, 10, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        panel.add((Component)this.m_numberOfCEErroneousEvents, c);
        c.insets = new Insets(0, 0, 5, 0);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panel.add(Box.createHorizontalStrut(1), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWToolbarBorder getGeneralPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_general.htm");
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.GeneralSettings, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_publishInterval = new VWTaskNumericProperty("");
        this.m_publishInterval.setName(VWResource.PublishingInterval);
        this.m_publishInterval.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_publishInterval.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_publishInterval, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_tempDir = new JTextField("");
        this.m_tempDir.setName(VWResource.TempDirectory);
        this.m_tempDir.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_tempDir.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_tempDir, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_numberPublisherThreads = new VWTaskNumericProperty("");
        this.m_numberPublisherThreads.setName(VWResource.PublisherThreads);
        this.m_numberPublisherThreads.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_numberPublisherThreads.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_numberPublisherThreads, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_javaMinMem = new VWTaskNumericProperty("");
        this.m_javaMinMem.setName(VWResource.JavaMinMemory);
        this.m_javaMinMem.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_javaMinMem.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_javaMinMem, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_javaMaxMem = new VWTaskNumericProperty("");
        this.m_javaMaxMem.setName(VWResource.JavaMaxMemory);
        this.m_javaMaxMem.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_javaMaxMem.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_javaMaxMem, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_ceURL = new JTextField();
        this.m_ceURL.setName(VWResource.ContentEngineURI);
        this.m_ceURL.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_ceURL.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_ceURL, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_serviceUserName = new JTextField();
        this.m_serviceUserName.setName(VWResource.ServiceUserName);
        this.m_serviceUserName.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_serviceUserName.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_serviceUserName, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_servicePassword = new JPasswordField();
        this.m_servicePassword.setName(VWResource.ServicePassword);
        this.m_servicePassword.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_servicePassword.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_servicePassword, (Object)c, true);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(borderPanel);
        return borderPanel;
    }

    private VWToolbarBorder getDatabasePanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_database.htm");
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.DatabaseSettings, 0, panel);
        VWTaskTabbedPane pane = new VWTaskTabbedPane();
        pane.addTab(VWResource.ProcessAnalyzerDatabase, this.getPADatabasePanel(), false);
        pane.addTab(VWResource.ProcessAnalyzerOLAPDatabase, this.getPAOLAPDatabasePanel(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)pane, c);
        VWTaskUtil.updateComponentOrientation(borderPanel);
        return borderPanel;
    }

    private VWTaskTabPanel getPADatabasePanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        this.m_paDBHost = new JTextField("");
        this.m_paDBHost.setEditable(false);
        this.m_paDBHost.setName(VWResource.DatabaseHost);
        this.m_paDBHost.addFocusListener(this);
        this.m_paDBPort = new VWTaskNumericProperty("");
        this.m_paDBPort.setName(VWResource.DatabasePort);
        this.m_paDBPort.addFocusListener(this);
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel(this.m_paDBHost.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((Component)this.getDatabaseHostPortPanel(this.m_paDBHost, this.m_paDBPort, true), c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paDBInstance = new JTextField("");
        this.m_paDBInstance.setEditable(false);
        this.m_paDBInstance.setName(VWResource.DatabaseInstance);
        this.m_paDBInstance.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paDBInstance.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paDBInstance, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paDBName = new JTextField("");
        this.m_paDBName.setEditable(false);
        this.m_paDBName.setName(VWResource.DatabaseName);
        this.m_paDBName.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paDBName.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paDBName, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paDBUser = new JTextField("");
        this.m_paDBUser.setName(VWResource.DatabaseUserName);
        this.m_paDBUser.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paDBUser.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paDBUser, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paDBPassword = new JPasswordField("");
        this.m_paDBPassword.setName(VWResource.DatabasePassword);
        this.m_paDBPassword.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paDBPassword.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paDBPassword, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paDBDriverName = new JTextField("");
        this.m_paDBDriverName.setName(VWResource.JDBCDriverName);
        this.m_paDBDriverName.addFocusListener(this);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paDBDriverName, (Object)c, true);
        this.m_paDBDriverName.setVisible(false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paDBDriverClasspath = new JTextArea();
        VWTaskUtil.updateComponentOrientation(this.m_paDBDriverClasspath);
        this.m_paDBDriverClasspath.setRows(4);
        this.m_paDBDriverClasspath.setLineWrap(true);
        this.m_paDBDriverClasspath.setName(VWResource.JDBCDriverClassPath);
        this.m_paDBDriverClasspath.addFocusListener(this);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        JScrollPane sp = new JScrollPane(this.m_paDBDriverClasspath, 20, 31);
        panel.add((Component)sp, c);
        sp.setVisible(false);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWTaskTabPanel getPAOLAPDatabasePanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paOLAPHost = new JTextField("");
        this.m_paOLAPHost.setEditable(false);
        this.m_paOLAPHost.setName(VWResource.DatabaseHost);
        this.m_paOLAPHost.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paOLAPHost.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paOLAPHost, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paOLAPInstance = new JTextField("");
        this.m_paOLAPInstance.setEditable(false);
        this.m_paOLAPInstance.setName(VWResource.DatabaseInstance);
        this.m_paOLAPInstance.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paOLAPInstance.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paOLAPInstance, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_paOLAPDBName = new JTextField("");
        this.m_paOLAPDBName.setEditable(false);
        this.m_paOLAPDBName.setName(VWResource.DatabaseName);
        this.m_paOLAPDBName.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_paOLAPDBName.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_paOLAPDBName, (Object)c, false);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWTaskTabPanel getPEDatabasePanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel(VWResource.DatabaseType + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        this.m_peDBType = new JComboBox<DatabaseTypeWrapper>(DatabaseTypeWrapper.getTypesArray());
        this.m_peDBType.setRenderer(new LocalListCellRenderer());
        panel.add((Component)this.m_peDBType, c);
        this.m_peDBType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dbtype = ((DatabaseTypeWrapper)PAPropertyPanel.this.m_peDBType.getSelectedItem()).getName();
                if (dbtype == DatabaseType.SQLSERVER.getName()) {
                    PAPropertyPanel.this.m_peDBDriverName.setText(PAPropertyPanel.MSSQL_JDBC_DRIVER);
                    PAPropertyPanel.this.m_peDBPort.setText(Integer.valueOf(1433).toString());
                } else if (dbtype == DatabaseType.ORACLE.getName()) {
                    PAPropertyPanel.this.m_peDBDriverName.setText(PAPropertyPanel.ORACLE_JDBC_DRIVER);
                    PAPropertyPanel.this.m_peDBPort.setText(Integer.valueOf(1521).toString());
                } else if (dbtype == DatabaseType.DB2.getName()) {
                    PAPropertyPanel.this.m_peDBDriverName.setText(PAPropertyPanel.DB2_JDBC_DRIVER);
                    PAPropertyPanel.this.m_peDBPort.setText(Integer.valueOf(50000).toString());
                }
            }
        });
        this.m_peDBHost = new JTextField("");
        this.m_peDBHost.setName(VWResource.DatabaseHost);
        this.m_peDBHost.addFocusListener(this);
        this.m_peDBPort = new VWTaskNumericProperty("");
        this.m_peDBPort.setName(VWResource.DatabasePort);
        this.m_peDBPort.addFocusListener(this);
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel(this.m_peDBHost.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((Component)this.getDatabaseHostPortPanel(this.m_peDBHost, this.m_peDBPort, !this.m_node.isSimulationMode()), c);
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_peDBName = new JTextField("");
        this.m_peDBName.setName(VWResource.DatabaseName);
        this.m_peDBName.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_peDBName.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_peDBName, (Object)c, !this.m_node.isSimulationMode());
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_peDBUser = new JTextField("");
        this.m_peDBUser.setName(VWResource.DatabaseUserName);
        this.m_peDBUser.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_peDBUser.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_peDBUser, (Object)c, !this.m_node.isSimulationMode());
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_peDBPassword = new JPasswordField("");
        this.m_peDBPassword.setName(VWResource.DatabasePassword);
        this.m_peDBPassword.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_peDBPassword.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_peDBPassword, (Object)c, false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_peDBDriverName = new JTextField("");
        this.m_peDBDriverName.setName(VWResource.JDBCDriverName);
        this.m_peDBDriverName.addFocusListener(this);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_peDBDriverName, (Object)c, !this.m_node.isSimulationMode());
        this.m_peDBDriverName.setVisible(false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_peDBDriverClasspath = new JTextArea();
        VWTaskUtil.updateComponentOrientation(this.m_peDBDriverClasspath);
        this.m_peDBDriverClasspath.setRows(4);
        this.m_peDBDriverClasspath.setLineWrap(true);
        this.m_peDBDriverClasspath.setName(VWResource.JDBCDriverClassPath);
        this.m_peDBDriverClasspath.addFocusListener(this);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        JScrollPane sp = new JScrollPane(this.m_peDBDriverClasspath, 20, 31);
        panel.add((Component)sp, c);
        sp.setVisible(false);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWTaskTabPanel getDatabaseHostPortPanel(JTextField hostField, VWTaskNumericProperty portField, boolean required) {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 5);
        panel.add((JTextComponent)hostField, (Object)c, required);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 1;
        c.insets = new Insets(0, 10, 0, 0);
        panel.add((Component)new JLabel(portField.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 2;
        c.insets = new Insets(0, 10, 0, 0);
        portField.setPreferredSize(new Dimension(60, portField.getPreferredSize().height));
        panel.add((JTextComponent)portField, (Object)c, required);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWTaskTabPanel getAdvancedPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_advanced.htm");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)this.getAdvancedSettingsPanel(), c);
        c.insets = new Insets(10, 0, 0, 0);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_loggingPanel = new VWTaskLoggingPanel();
        panel.add((Component)this.m_loggingPanel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWToolbarBorder getAdvancedSettingsPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.AdvancedSettings, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_registryPort = new VWTaskNumericProperty("");
        this.m_registryPort.setName(VWResource.RegistryPort);
        this.m_registryPort.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_registryPort.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_registryPort, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_dimensionCacheSize = new VWTaskNumericProperty("");
        this.m_dimensionCacheSize.setName(VWResource.DimCachedRowsPerTable);
        this.m_dimensionCacheSize.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_dimensionCacheSize.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_dimensionCacheSize, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_factCacheSize = new VWTaskNumericProperty("");
        this.m_factCacheSize.setName(VWResource.FactCachedRowsPerTable);
        this.m_factCacheSize.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_factCacheSize.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_factCacheSize, (Object)c, true);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)new JLabel(VWResource.AdjustedMeasures + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        String[] items = new String[]{VWResource.On, VWResource.Off};
        this.m_showAdjMeasures = new JComboBox<String>(items);
        this.m_showAdjMeasures.setRenderer(new LocalListCellRenderer());
        panel.add((Component)this.m_showAdjMeasures, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return borderPanel;
    }

    protected boolean validateProperties() {
        try {
            this.m_tabbedPane.validateProperties();
            int javaMinMem = Integer.parseInt(this.m_javaMinMem.getText().trim());
            int javaMaxMem = Integer.parseInt(this.m_javaMaxMem.getText().trim());
            if (javaMaxMem < javaMinMem) {
                throw new Exception(VWResource.InvalidJavaMemory);
            }
        }
        catch (Exception e) {
            VWTaskCore.getInstance().displayError((Throwable)e, false);
            return false;
        }
        return true;
    }

    public boolean hasValidPEDBConfiguration() {
        return !this.m_peDBHost.getText().trim().equals("") && !this.m_peDBPort.getText().trim().equals("") && !this.m_peDBName.getText().trim().equals("") && !this.m_peDBUser.getText().trim().equals("");
    }

    private void refreshLayout() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   25 Feb 2009 13:22:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.43  $";
    }

    private VWToolbarBorder getProcessEnginePanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_pe.htm");
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ProcessEngineSettings, 0, panel);
        VWTaskTabbedPane pane = new VWTaskTabbedPane();
        pane.addTab(VWResource.General, this.getProcessEngineGeneralPanel());
        this.m_eventLogPanel = new EventLogMainPanel(this.m_node);
        pane.addTab(VWResource.ProcessEngineDatabase, this.getPEDatabasePanel(), false);
        pane.addTab(VWResource.EventLogs, this.m_eventLogPanel, false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)pane, c);
        VWTaskUtil.updateComponentOrientation(borderPanel);
        return borderPanel;
    }

    private VWTaskTabPanel getProcessEngineGeneralPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_general.htm");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_peProcessEvents = new JCheckBox(VWResource.ProcessEventsForPE);
        this.m_peProcessEvents.addFocusListener(this);
        panel.add((Component)this.m_peProcessEvents, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWToolbarBorder getContentEnginePanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "pa_prop_ce.htm");
        VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.ContentEngineSettings, 0, panel);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 5);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_ceProcessEvents = new JCheckBox(VWResource.ProcessEventsForCE);
        this.m_ceProcessEvents.addFocusListener(this);
        this.m_ceProcessEvents.addActionListener(this);
        panel.add((Component)this.m_ceProcessEvents, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.m_ceObjectStore = new JTextField();
        this.m_ceObjectStore.setName(VWResource.ObjectStoreName);
        this.m_ceObjectStore.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_ceObjectStore.getName() + ":"), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        panel.add((JTextComponent)this.m_ceObjectStore, (Object)c, true);
        c.insets = new Insets(0, 0, 0, 0);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add(Box.createHorizontalStrut(0), c);
        VWTaskUtil.updateComponentOrientation(borderPanel);
        return borderPanel;
    }

    public class LocalListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.setComponentOrientation(compOrientation);
            return this;
        }
    }

    private static class DatabaseTypeWrapper {
        private DatabaseType type = null;
        private String displayName = null;
        private static Map instanceMap = new HashMap(5);
        public static DatabaseTypeWrapper TYPE_SQLSERVER = new DatabaseTypeWrapper(DatabaseType.SQLSERVER, VWResource.DATABASE_SQLSERVER);
        public static DatabaseTypeWrapper TYPE_ORACLE = new DatabaseTypeWrapper(DatabaseType.ORACLE, VWResource.DATABASE_ORACLE);
        public static DatabaseTypeWrapper TYPE_DB2 = new DatabaseTypeWrapper(DatabaseType.DB2, VWResource.DATABASE_DB2);

        public static DatabaseTypeWrapper valueOf(String name) {
            if (instanceMap.containsKey(name)) {
                return (DatabaseTypeWrapper)instanceMap.get(name);
            }
            throw new IllegalArgumentException("Invalid database type: " + name);
        }

        public static DatabaseTypeWrapper[] getTypesArray() {
            DatabaseTypeWrapper[] dbTypes = new DatabaseTypeWrapper[]{TYPE_SQLSERVER, TYPE_ORACLE, TYPE_DB2};
            return dbTypes;
        }

        private DatabaseTypeWrapper(DatabaseType t, String dispName) {
            this.type = t;
            this.displayName = dispName;
            instanceMap.put(t.getName(), this);
        }

        public String getName() {
            return this.type.getName();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }

    private class ConnectedRegionsPanel
    extends JPanel {
        private Integer[] regions = null;
        private JTextArea regionsTxtArea = null;
        private JList regionsList = null;

        public ConnectedRegionsPanel() {
            this.setLayout(new GridBagLayout());
        }

        private void setRegions(Integer[] newRegions) {
            if (newRegions != null) {
                Arrays.sort((Object[])newRegions);
            }
            if (Arrays.equals((Object[])this.regions, (Object[])newRegions)) {
                return;
            }
            this.regions = newRegions;
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(2, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 3;
            if (this.regions == null) {
                this.removeAll();
                JTextField f = new JTextField("---");
                f.setEditable(false);
                f.setBorder(null);
                this.add((Component)f, c);
            } else if (this.regions.length <= 5) {
                if (this.regionsTxtArea == null) {
                    this.removeAll();
                    this.regionsTxtArea = new JTextArea();
                    this.regionsTxtArea.setLineWrap(true);
                    this.regionsTxtArea.setWrapStyleWord(true);
                    this.regionsTxtArea.setEditable(false);
                    this.regionsTxtArea.setBackground(VWTaskCore.getInstance().getMainFrame().getContentPane().getBackground());
                    this.regionsTxtArea.setColumns(5);
                    VWTaskUtil.updateComponentOrientation(this.regionsTxtArea);
                    this.add((Component)this.regionsTxtArea, c);
                }
                StringBuffer b = new StringBuffer();
                for (int i = 0; i < this.regions.length; ++i) {
                    b.append(this.regions[i]);
                    if (i >= this.regions.length - 1) continue;
                    b.append("\n");
                }
                this.regionsTxtArea.setText(b.toString());
            } else {
                Integer selectedRegion = this.regionsList != null ? (Integer)this.regionsList.getSelectedValue() : null;
                this.removeAll();
                this.regionsList = new JList<Integer>(this.regions);
                if (selectedRegion != null && Arrays.binarySearch((Object[])this.regions, selectedRegion) >= 0) {
                    this.regionsList.setSelectedValue(selectedRegion, true);
                    this.regionsList.ensureIndexIsVisible(this.regionsList.getSelectedIndex());
                }
                this.regionsList.setVisibleRowCount(this.regions.length <= 5 ? this.regions.length : 5);
                this.regionsList.setPreferredSize(new Dimension(50, (int)this.regionsList.getPreferredSize().getHeight()));
                JScrollPane scrollPane = new JScrollPane(this.regionsList);
                scrollPane.setHorizontalScrollBarPolicy(31);
                scrollPane.setVerticalScrollBarPolicy(22);
                c.insets = new Insets(5, 0, 0, 0);
                this.add((Component)scrollPane, c);
            }
            PAPropertyPanel.this.refreshLayout();
        }

        public void removeAll() {
            super.removeAll();
            this.regionsTxtArea = null;
            this.regionsList = null;
        }
    }
}

